 /***************************************************
 *
 *  DESCRIPTION: Atomic Model Base Station Processor
 *
 *  AUTHOR: Misagh Tavanpour
 *
 *  DATE: 25/10/2012
 *
 ****************************************************/

 #ifndef __BSprocessor2_H
 #define __BSprocessor2_H

 #include "atomic.h"      // class Atomic
 #include "string.h"	  // class String

 class BSprocessor2 : public Atomic
 {
   public:
	       BSprocessor2 ( const std::string &name = "BSprocessor2" );  //Default constructor
	       virtual std::string className() const {  return "BSprocessor2" ;}
	       ~BSprocessor2();

   protected:
	          Model &initFunction();
	          Model &externalFunction( const ExternalMessage & );
	          Model &internalFunction( const InternalMessage & );
	          Model &outputFunction( const InternalMessage & );

   private:
	        const Port &In;
	        Port &OB0,&OB1,&OB3,&OB4,&OB5,&OB6,&OU1,&Req;
	        Time ProcessTime;
	        int Temp,i,j,CurrentCell;
	        int UEinBS [7][3];
	        int NextHop [10];
	        int Neighborhood [7];
	        int Digit [6];
	        int MyUEMode [3];
	        int Turn;
	        int BSMes1,BSMes2,BSMes1Port,BSMes2Port;
	        int UECoordinationSet [3][3];
	        int OutPort;
         	enum State{
			            Idle,
			            SetCSMode,
			            NormalMode,
			            InfoMode,
			            AskNewTask,
		              };
		    State state;
 };

#endif   //__BSprocessor2_H
